local Assets =
{
	Asset("ANIM", "anim/firefly.zip"), 
	Asset("IMAGE", "images/inventoryimages/firefly.tex"),
    Asset("ATLAS", "images/inventoryimages/firefly.xml"),    
}

local function healowner(inst, owner)
    if (owner.components.health and owner.components.health:IsHurt()) then
        owner.components.health:DoDelta(3,1)
end
end

local function hurtowner(inst, owner)
	if (owner.components.health) then
		owner.components.health:DoDelta(-3,-1)
end
end

local function onequip(inst, owner) 
    if owner:HasTag("antirad") then
	owner.AnimState:OverrideSymbol("swap_body", "firefly", "swap_body")
	inst.task = inst:DoPeriodicTask(15, healowner, nil, owner)
	owner:AddTag("rad")
	else
	owner.AnimState:OverrideSymbol("swap_body", "firefly", "swap_body")
	inst.task = inst:DoPeriodicTask(2, hurtowner, nil, owner)
	owner:AddTag("rad")

	end
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	owner:RemoveTag("rad")

	if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
    end
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    	
    inst.AnimState:SetBank("firefly")
    inst.AnimState:SetBuild("firefly")
    inst.AnimState:PlayAnimation("idle", false)
		
	inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/firefly.xml"
	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BACK or EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
		
	inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 20
	
	if IsDLCEnabled(0002) then
	MakeInventoryFloatable(inst, "anim", "anim")
	end
	
    return inst
end


return Prefab( "common/inventory/firefly", fn, Assets)

